/* ///////////////////////////////////////////////////////////////////////// */
/*  This is part of the source of the OMAP 5912 heterogeneous dual-core      */
/*  MPEG-4 SP video decoder published in ACM Transactions on Embedded        */
/*  Computing Systems, Vol. X, Issue Y.                                      */
/* ------------------------------------------------------------------------- */
/*  The source code is released under GPL license.                           */
/*                                                                           */
/*  Copyright, 2011                                                          */
/*  Multimedia Embedded Systems Labs                                         */
/*  Dept. of Computer Science                                                */
/*  National Chiao Tung University                                           */
/*  Hsinchu, Taiwan.                                                         */
/* ///////////////////////////////////////////////////////////////////////// */

#include <stdio.h>

#include <soc.h>
#include <csl_dspmmu.h>

#include "metypes.h"

//#define SDRAM 0x11200000
//#define SRAM  0x20000000
//#define SHARE_MEM SDRAM

CSL_DspmmuObj dspmmuObj1;
#define MMU_EN_CTRL_REG *((volatile unsigned int *) 0xFFFECC34) // Endian Control
//CSL_DspmmuObj    dspmmuObj2;
//CSL_DspmmuObj    dspmmuObj3;

//uint16  *share_sdram = (uint16 *)SDRAM;
//uint32  virtual_addr = 0xD00000;

xint
dspmmu_setup()
{
    CSL_Status status;
    CSL_DspmmuHandle hDspmmu = NULL;
    CSL_DspmmuHwSetup dspmmuHwsetup = {
        CSL_DSPMMU_WLKLGC_DISABLE,
        0x00000000,
        CSL_DSPMMU_RSTMODE_DISABLE,
        CSL_DSPMMU_PWRDWNMODE_DISABLE,
        CSL_DSPMMU_AUTOGTNG_ENABLE
    };
    CSL_DspmmuTlbEntry entry = { 0 };

    /* Initialize the DSP MMU */
    CSL_dspmmuInit(NULL);

    /* Open the DSP MMU Instance */
    hDspmmu = CSL_dspmmuOpen(&dspmmuObj1, CSL_DSPMMU, NULL, &status);
    if (status != CSL_SOK)
    {
        printf("Error opening the instance\n");
        return 1;
    }

    /* perform the hardware setup for DSP MMU */
    CSL_dspmmuHwSetup(hDspmmu, &dspmmuHwsetup);

    if (CSL_SOK !=
        CSL_dspmmuHwControl(hDspmmu, CSL_DSPMMU_CMD_RESETRELEASEMMU, NULL))
    {
        printf("Error reset release of MMU\n");
        CSL_dspmmuClose(hDspmmu);
        return 1;
    }

    if (CSL_SOK != CSL_dspmmuHwControl(hDspmmu, CSL_DSPMMU_CMD_ENABLEMMU, NULL))
    {
        printf("Error enable dsp mmu \n");
        CSL_dspmmuClose(hDspmmu);
        return 1;
    }

    MMU_EN_CTRL_REG = 0;        //endian register   
    printf("Turn on DSP MMU\n");
    entry.virtualAddr = 0x080000;
    entry.phyAddr = (void *) 0x11400000;
    entry.slstBit = CSL_DSPMMU_PAGE_SECTION;
    entry.pBit = CSL_DSPMMU_NOT_PRESERVED;
    entry.apBit = CSL_DSPMMU_ACCESS_FULL;
    entry.baseValue = 0x0;
    entry.victim = 0;           // write entry 0 of TLB
    entry.valid = CSL_DSPMMU_VALID;
    CSL_dspmmuUpdateTlbEntry(hDspmmu, &entry);
    // printf("Entry %d : Virtual Address = 0x%x, Physical Address = 0x%x \n",
    //      entry.victim, entry.virtualAddr, entry.phyAddr);

    entry.virtualAddr = 0x500000;
    entry.phyAddr = (void *) 0x11200000;
    entry.slstBit = CSL_DSPMMU_PAGE_SECTION;
    entry.pBit = CSL_DSPMMU_NOT_PRESERVED;
    entry.apBit = CSL_DSPMMU_ACCESS_FULL;
    entry.baseValue = 0x0;
    entry.victim = 1;           // write entry 1 of TLB
    entry.valid = CSL_DSPMMU_VALID;
    CSL_dspmmuUpdateTlbEntry(hDspmmu, &entry);
    // printf("Entry %d : Virtual Address = 0x%x, Physical Address = 0x%x \n",
    //       entry.victim, entry.virtualAddr, entry.phyAddr);

    entry.virtualAddr = 0x600000;
    entry.phyAddr = (void *) 0x11600000;
    entry.slstBit = CSL_DSPMMU_PAGE_SECTION;
    entry.pBit = CSL_DSPMMU_NOT_PRESERVED;
    entry.apBit = CSL_DSPMMU_ACCESS_FULL;
    entry.baseValue = 0x0;
    entry.victim = 2;           // write entry 0 of TLB
    entry.valid = CSL_DSPMMU_VALID;
    CSL_dspmmuUpdateTlbEntry(hDspmmu, &entry);
    // printf("Entry %d : Virtual Address = 0x%x, Physical Address = 0x%x \n",
    //       entry.victim, entry.virtualAddr, entry.phyAddr);

    entry.virtualAddr = 0x700000;
    entry.phyAddr = (void *) 0x11700000;
    entry.slstBit = CSL_DSPMMU_PAGE_SECTION;
    entry.pBit = CSL_DSPMMU_NOT_PRESERVED;
    entry.apBit = CSL_DSPMMU_ACCESS_FULL;
    entry.baseValue = 0x0;
    entry.victim = 3;           // write entry 1 of TLB
    entry.valid = CSL_DSPMMU_VALID;
    CSL_dspmmuUpdateTlbEntry(hDspmmu, &entry);
    // printf("Entry %d : Virtual Address = 0x%x, Physical Address = 0x%x \n",
    //       entry.victim, entry.virtualAddr, entry.phyAddr);

    return 0;
}
